#include <stdio.h>
#include <stdlib.h>
// fonction qui calcule le min entre 2 entier
int min(int a, int b)
{
  if(a<b) {return a;}
  else {return b;}
}
// idem mais max entre 2 entier
int max(int a, int b)
{
  if(a>b) {return a;}
  else {return b;}
}
// fonction de réarrangement
// pour un couple (i,j) dans (N,N), on calcule 
// l'indice k dans (N*N) correspondant
int rearrange(int i,int j,int N)
{
  return i*N+j;
}
// fonction d'affichage, a eviter en parallele
void affichage(int N, int vie[])
{
  int i,j;
  
  for(i=0;i<N;i++)
  {
    for(j=0;j<N;j++)
    {
      if(vie[rearrange(i,j,N)] == 0)
      { printf("  ");}
      else
      { printf("[]");}
    }
    printf("\n");
  } 
}
// initialisation avec un planeur
// a remplacer selon les envies
void initialisation(int N, int *vie)
{
  int i,j;
  for(i=0;i<N;i++){
    for(j=0;j<N;j++){
      vie[rearrange(i,j,N)]=0;
    }
  }
  vie[rearrange(3,1,N)]=1;
  vie[rearrange(3,2,N)]=1;
  vie[rearrange(3,3,N)]=1;
  vie[rearrange(2,3,N)]=1;
  vie[rearrange(1,2,N)]=1;

}

// fonction qui calcule une iteration
// du probleme
void iter(int N, int vie[])
{
  int i,j,k,l,km,kp,lm,lp;
  int vivant=0;
  int mort=0;
  int temp[N*N];
  // on copie les valeurs dans un tableau temporaire
  for(i=0;i<N*N;i++)
  { 
     temp[i]=vie[i];
  }
  // boucle sur les elements horizontaux
  for(i=0;i<N;i++)
  { 
    // Test du bord
    km=max(i-1,0);
    kp=min(i+1,N-1);
    // boucle sur les element verticaux
    for(j=0;j<N;j++)
    {
      vivant=0;
      // test du bord
      lm=max(j-1,0);
      lp=min(j+1,N-1);
      // boucle sur les elements adjacents [i-1 : i+1 ]
      for(k=km;k<=kp;k++)
      {
        for(l=lm;l<=lp;l++) // idem [j-1 : j+1]
        { // on compte les voisins vivants en evitant de se compter soit meme !
          if(rearrange(i,j,N) != rearrange(k,l,N) & vie[rearrange(k,l,N)]==1)
          { vivant ++; }
        }
      }
      mort = 8 - vivant; // nombre de morts
      // test de nativite ou mortalite
      if(vie[rearrange(i,j,N)]==0 & vivant==3) // Si une cellule morte possede 3 voisines vivantes
      {  temp[rearrange(i,j,N)]=1;}            // Elle nait
      if(vie[rearrange(i,j,N)]==1 & (vivant<2 | vivant >3) ) // Si un cellule vivante possede moins de 2
      {  temp[rearrange(i,j,N)]=0;}            // ou  plus de 3 voisin vivant, elle meurt
    }
  }
  // on copie finalement dans le tableau initial
  for(i=0;i<N*N;i++)
  { 
     vie[i]=temp[i];
  }

}
// fonction principale
int main(int argc, char* argv[])
{
  const int N=10; //taille du probleme
  int *vie; 
  int it=0,Nt = 50;
  //allocation dynamique tableau d'entier
  // ici le tableau (N,N) est tranforme en 
  // un vecteur de taille N*N
  vie = malloc(N*N*sizeof(double));
  
  initialisation(N,vie); 
  while(it<Nt)
  {
    affichage(N,vie);
    iter(N,vie);
    it ++;
  }

  return 0;
}
