#include<stdio.h>
#include<stdlib.h>
#include<math.h>
/*
  Fonction calculant le second membre des equations du mvt
  ici d2u/dt2 = -(EI/(rhoS))*d4u/dx4 + NL
  avec NL = (1/2)*(E/rho) . (du/dx)^2 . d2u/dx2
*/
double secondMembre(int N,double dt,double dx,double E, double rho, double S, double I, double F, double *u, double *SM)
{
  int i;
  double du,d2u,d3u,d4u,NL,lin;
  double clin, cnl, cm,cmax=0.,maxu=0.;
  // application des CL
  // bord encastre u = 0, du/dx = 0
  u[0] = 0.;  u[1] = 0.;  SM[0]= 0.;  SM[1]= 0.;
  // bord encastre
  u[N-2] = 0.; u[N-1] = 0.;  SM[N-2]= 0.;  SM[N-1]= 0.;
  // on ne resoud qu'a l'interieur du domaine, les autres points sont les CL
  for(i=2;i<N-2;i++)
  {
  // differences finies ordre 2
    // derivee premiere
    du = (u[i+1] - u[i-1])/(2.0*dx);
    // derivee seconde
    d2u = (u[i+1] - 2.0*u[i] + u[i-1])/(dx*dx);
    // derivee quatrieme
    d4u = (u[i+2] - 4.0*u[i+1] + 6.0*u[i] -4.0*u[i-1] + u[i-2])/(dx*dx*dx*dx);
    // terme Non lineaire
    NL = -(E/rho)*0.5*du*du*d2u;
    // terme de flexion lineaire
    lin = -(E*I/(rho*S))*d4u + dx*F;
    // calcul du second membre
    SM[i] = lin +NL;
    // calcul des vitesses d'ondes
    maxu = fmax(fabs(u[i]),maxu); 
  }
  clin = sqrt((6.0*E*I)/(rho*S));
  cnl  = sqrt(2.0*E/rho)*maxu;
  if(maxu<1.0e-14) cnl = 0.;
  //printf("%lf %lf %lf\n",maxu,cnl,clin);
  cm = fmax( clin , cnl);
  cmax = fmax(cm,cmax);
  return cmax;
}
/*
  Fonction qui integre u et v sur 1 pas de temps
  Schema Euler explicite ordre 1
  u^(n+1) = u^n + dt . SMB
*/
void integre(int N,double dt,double *u, double *v,double *SM)
{
  int i;
  // on exclut les points limites
  for(i=0;i<N;i++)
  {
    // schema Euler
    v[i] = v[i] + dt*SM[i]; 
    u[i] = u[i] + dt*v[i];
  }
}
/*
  Fonction qui ecrit dans un fichier
  les resultat. couple x(i), u(i)
*/
void ecriture(FILE *fichier,int N, double dx,double *u)
{
   int i;
   for(i=0;i<N;i++)
   { 
     // ecriture
     fprintf(fichier,"%.12lf %.12lf\n",((double)i+0.5)*dx,u[i]);
   }
}
/*  FONCTION PRINCIPALE */
int main(){

  int N,Nt,i,it;
  double E,b,h,S,I,rho,dt,F,cm = 0.;
  double *u,*v,*SM,dx;
  double du,d2u,d3u,d4u,NL;

  FILE* fres = fopen("def.dat","w");
  FILE* finit = fopen("def_init.dat","w");
  FILE* fparam = fopen("param.dat","r+");
  // donnees du pb
  fscanf(fparam,"%d",&N);// initialisation des données
  fscanf(fparam,"%d",&Nt);
  printf("%d %d\n",N,Nt);

  dx = 1.0/(double) N;
  E = 1.0e9;  rho = 1.0e3; b = 0.02; h = 0.02;
  S = b*h; I = b*h*h*h/12.0; F = -1000.0;
  dt = 1.0e-10;
  // allocation memoire
  u = malloc(N*sizeof(double));
  v = malloc(N*sizeof(double));
  SM= malloc(N*sizeof(double));
  // initialisation
  for(i=0;i<N;i++)
  {
    u[i] = 0.; v[i] = 0.; SM[i]= 0.;
  }
  ecriture(finit,N,dx,u);
  // boucle temporelle
  for(it=0;it<Nt;it++)
  { 
    // calcul du second membre sur tous les points
    cm = secondMembre(N,dt,dx,E,rho,S,I,F,u,SM);
    dt = 0.5*dx*dx/cm; // calcul du pas de temps admissible
    integre(N,dt,u,v,SM);// integration temporelle
  }
  // sauvegarde du resultat
  ecriture(fres,N,dx,u);
  // desallocation memoire
  fclose(fres); fclose(finit);
  free(u); free(v); free(SM);
  return 0;
}
