#ifndef vector__h
#define vector__h
/////////////////////////////////////////////////////////////////////////////
///
/// Very simple class of vectors of double.
/// \note indices start a 1!
////////////////////////////////////////////////////////////////////////////
class vector
{
  //! container
  double *x;
  //! size
  int n;
public:
  //! constructor
  //! \param _n size
  vector(int _n):n(_n)
  {
    x=new double[n];
  }
  //! destructor
  ~vector()
  {
    delete[] x;
  }
  //! returns a pointer to the datas
  // \note const!
  inline double* data() const {return x;}
  //! return the size
  inline int size() const {return n;}
  //!  initialization by a constant.
  inline void operator=(double v)
  {
    for(int i=0;i<n;i++)
      x[i]=v;
  }
  //! right hand side access operatour
  //! \note indices start a 1!
  double operator()(int i) const
  {
    return x[i-1];
  }
  //! left and right hand side access operator
  //! \note indices start a 1!
  double& operator()(int i) 
  {
    return x[i-1];
  }
};
#endif
