#include <iostream>
#include <fstream>
#include "vector.hpp"

using namespace std;

const double a = 1.;
const double b = 3;

void rk4(int n, vector& u, double t0, double t1, 
	 void f(vector&,vector&)) {

  vector utp(n);
  vector k1(n);
  vector k2(n);
  vector k3(n);
  vector k4(n);
  
  double dt = t1 - t0;

  // k1 = f(u)
  f(u,k1);

  // k2 = f(u+0.5*dt*k1)
  for (int i = 1 ; i <= n ; i++) utp(i) = u(i) + 0.5*dt*k1(i);
  f(utp,k2);

  // k3 = f(u+0.5*dt*k2)
  for (int i = 1 ; i <= n ; i++) utp(i) = u(i) + 0.5*dt*k2(i);
  f(utp,k3);

  // k4 = f(u+dt*k3)
  for (int i = 1 ; i <= n ; i++) utp(i) = u(i) + dt*k3(i);
  f(utp,k4);

  // u = u + dt/6 * (k1 + 2*k2 + 2*k3 + k4)
  for (int i = 1 ; i <= n ; i++) 
    u(i) = u(i) + dt/6.*(k1(i) + 2.*k2(i) + 2.*k3(i) + k4(i));
}

void bruss(vector& u ,vector& du) {
  du(1) =  a - (b+1.)*u(1) + u(1)*u(1)*u(2);
  du(2) = b*u(1) - u(1)*u(1)*u(2);
}

void brussinit(int n, vector& s) {
  s(1) = 1.5;
  s(2) = 3.;
}


int main(int argv, char** argc) {

  // Parametres du brusselator
  int n = 2;
  vector s(n); // Solution

  // Parametres de la resolution
  double t = 0.;
  double t0,t1;
  double tend = 30.;
  double dt = 0.01;
  int it = 1;
  int itmax = int(tend-t)/dt;

  // Fichier de sauvegarde
  ofstream fsav("sol");

  // Initialisation
  brussinit(n,s);

  while (t <= tend) {

    t0 = t;
    t1 = t+dt;
    rk4(n,s,t0,t1,&bruss);
    t+=dt;
    cout << "Iteration " << it << " Temps " << t << endl;
    it++;
    // Sauvegarde
    fsav << t << " ";
    for (int i = 1 ; i <= n ; i++) fsav << s(i) << " ";
    fsav << endl;
  }

  return 0;
}

